﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucEventEdit.ascx.cs" Inherits="ucEventEdit" %>
<script type="text/javascript">
    fnValForm = function () {
        if (App.tfEDPWEventTitle.isValid() && App.dfEDPWEventDate.isValid()) {
            App.btnEvtEditOK.setDisabled(false);
        }
        else {
            App.btnEvtEditOK.setDisabled(true);
        }
    };

    function AriaEvtRditOKBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaEvtEditCancelBtn(el) {
        el.set({
            "role": 'button'
        });
    }

</script>
<ext:Window ID="wndEventEdt" Title="Edit Title and Date" Hidden="true"
    Layout="AnchorLayout" Height="200" Width="325" 
     IDMode="Static" runat="server" 
    Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Items>

        <ext:Panel Border="false" Layout="AnchorLayout" runat="server" Padding="3" Width="310">
            <Items>

                <ext:TextField FieldLabel="Title" LabelWidth="40" AutoDataBind="true"
                    Padding="3" ID="tfEDPWEventTitle" ReadOnly="false" Width="300" runat="server"
                    Vtype="alphanumSpace">
                    <Listeners>
                        <Change Fn="fnValForm" />
                    </Listeners>
                </ext:TextField>

                <ext:DateField ID="dfEDPWEventDate"
                    runat="server"
                    AllowBlank="false"
                    FieldLabel="Date" LabelWidth="40"
                    AutoDataBind="true"
                    Width="150"
                    Padding="3"
                    Format="MM/dd/yyyy"
                    Note="MM/DD/YYYY"
                    NoteAlign="Down"
                    Vtype="date"
                    InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                    <Listeners>
                        <Change Fn="fnValForm" />
                    </Listeners>
                </ext:DateField>

                <ext:Checkbox ID="chkEDPWAdjustFuture"
                    runat="server"
                    BoxLabel="Adjust Future Dates?"  
                    HideEmptyLabel="true" Padding="3">
                </ext:Checkbox>

            </Items>
        </ext:Panel>


    </Items>
    <BottomBar>
        <ext:Toolbar runat="server">
            <Items>

                <ext:Button ID="btnEvtEditOK" runat="server" Text="OK" Icon="Disk" TabIndex="100">
                    <Listeners>
                        <AfterRender Handler="AriaEvtRditOKBtn(App.btnEvtEditOK.getEl());" ></AfterRender>
                    </Listeners>
                    <DirectEvents>
                        <Click OnEvent="OnEvtEditOK" 
                            Before="App.btnEvtEditOK.setDisabled(true)"
                            Success="App.btnEvtEditOK.setDisabled(false);App.direct.PATSUMMARY.ReloadPWEvtNodes();">
                            <ExtraParams>
                            </ExtraParams>
                        </Click>
                    </DirectEvents>
                </ext:Button>

                <ext:Button ID="btnEvtEditCancel" TabIndex="200" runat="server" Text="Cancel" Icon="Cancel" Handler="App.wndEventEdt.hide();" >
                <Listeners>
                       <AfterRender Handler="AriaEvtEditCancelBtn(App.btnEvtEditCancel.getEl());" ></AfterRender>
                </Listeners>
                </ext:Button>

            </Items>
        </ext:Toolbar>
    </BottomBar>
    <Listeners>
        <Show Handler="Ext.defer(function() {App.tfEDPWEventTitle.focus(true, 100);}, 1);" />
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />

    </Listeners>
   
</ext:Window>
